---@meta

---
---
---
---[查看文档](command:extension.lua.doc?["en-us/54/manual.html/pdf-table"])
---
---@class tablelib
table = {}

---
---Given a list where all elements are strings or numbers, returns the string `list[i]..sep..list[i+1] ··· sep..list[j]`.
---
---[查看文档](command:extension.lua.doc?["en-us/54/manual.html/pdf-table.concat"])
---
---@param list table
---@param sep? string
---@param i?   integer
---@param j?   integer
---@return string
---@nodiscard
function table.concat(list, sep, i, j) end

---
---Inserts element `value` at position `pos` in `list`.
---
---[查看文档](command:extension.lua.doc?["en-us/54/manual.html/pdf-table.insert"])
---
---@overload fun(list: table, value: any)
---@param list table
---@param pos integer
---@param value any
function table.insert(list, pos, value) end

---@version <5.1
---
---Returns the largest positive numerical index of the given table, or zero if the table has no positive numerical indices.
---
---[查看文档](command:extension.lua.doc?["en-us/54/manual.html/pdf-table.maxn"])
---
---@param table table
---@return integer
---@nodiscard
function table.maxn(table) end

---@version >5.3
---
---Moves elements from table `a1` to table `a2`.
---```lua
---a2[t],··· =
---a1[f],···,a1[e]
---return a2
---```
---
---
---[查看文档](command:extension.lua.doc?["en-us/54/manual.html/pdf-table.move"])
---
---@param a1  table
---@param f   integer
---@param e   integer
---@param t   integer
---@param a2? table
---@return table a2
function table.move(a1, f, e, t, a2) end

---@version >5.2, JIT
---
---返回用所有参数以键 `1`,`2`, 等填充的新表， 并将 `"n"` 这个域设为参数的总数。
---
---[查看文档](command:extension.lua.doc?["en-us/54/manual.html/pdf-table.pack"])
---
---@return table
---@nodiscard
function table.pack(...) end

---
---移除 `list` 中 `pos` 位置上的元素，并返回这个被移除的值。
---
---[查看文档](command:extension.lua.doc?["en-us/54/manual.html/pdf-table.remove"])
---
---@param list table
---@param pos? integer
---@return any
function table.remove(list, pos) end

---
---在表内从 `list[1]` 到 `list[#list]` *原地* 对其间元素按指定次序排序。
---
---[查看文档](command:extension.lua.doc?["en-us/54/manual.html/pdf-table.sort"])
---
---@generic T
---@param list T[]
---@param comp? fun(a: T, b: T):boolean
function table.sort(list, comp) end

---@version >5.2, JIT
---
---返回列表中的元素。 这个函数等价于
---```lua
---    return list[i], list[i+1], ···, list[j]
---```
---i 默认为 1 ，j 默认为 #list。
---
---
---[查看文档](command:extension.lua.doc?["en-us/54/manual.html/pdf-table.unpack"])
---
---@generic T
---@param list T[]
---@param i?   integer
---@param j?   integer
---@return T
---@nodiscard
function table.unpack(list, i, j) end

---@version <5.1, JIT
---
---遍历表中的每一个元素，并以key和value执行回调函数。如果回调函数返回一个非nil值则循环终止,并且返回这个值。该函数等同pair(list),比pair(list)更慢。不推荐使用
---
---[查看文档](command:extension.lua.doc?["en-us/54/manual.html/pdf-table.foreach"])
---
---@generic T
---@param list any
---@param callback fun(key: string, value: any):T|nil
---@return T|nil
---@deprecated
function table.foreach(list, callback) end

---@version <5.1, JIT
---
---遍历数组中的每一个元素，并以索引号index和value执行回调函数。如果回调函数返回一个非nil值则循环终止,并且返回这个值。该函数等同ipair(list),比ipair(list)更慢。不推荐使用
---
---[查看文档](command:extension.lua.doc?["en-us/54/manual.html/pdf-table.foreachi"])
---
---@generic T
---@param list any
---@param callback fun(key: string, value: any):T|nil
---@return T|nil
---@deprecated
function table.foreachi(list, callback) end

---@version <5.1, JIT
---
---返回表的长度。该函数等价于#list。
---
---[查看文档](command:extension.lua.doc?["en-us/54/manual.html/pdf-table.getn"])
---
---@generic T
---@param list T[]
---@return integer
---@nodiscard
---@deprecated
function table.getn(list) end

---@version JIT
---
---This creates a pre-sized table, just like the C API equivalent `lua_createtable()`. This is useful for big tables if the final table size is known and automatic table resizing is too expensive. `narray` parameter specifies the number of array-like items, and `nhash` parameter specifies the number of hash-like items. The function needs to be required before use.
---```lua
---    require("table.new")
---```
---
---
---[查看文档](command:extension.lua.doc?["en-us/54/manual.html/pdf-table.new"])
---
---@param narray integer
---@param nhash integer
---@return table
function table.new(narray, nhash) end

---@version JIT
---
---This clears all keys and values from a table, but preserves the allocated array/hash sizes. This is useful when a table, which is linked from multiple places, needs to be cleared and/or when recycling a table for use by the same context. This avoids managing backlinks, saves an allocation and the overhead of incremental array/hash part growth. The function needs to be required before use.
---```lua
---    require("table.clear").
---```
---Please note this function is meant for very specific situations. In most cases it's better to replace the (usually single) link with a new table and let the GC do its work.
---
---
---[查看文档](command:extension.lua.doc?["en-us/54/manual.html/pdf-table.clear"])
---
---@param tab table
function table.clear(tab) end

return table
